/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.core.AgentContainerImpl;
import jade.core.Profile;
import jade.core.TimerDispatcher;
import jade.util.Logger;
import jade.util.leap.LinkedList;
import jade.wrapper.AgentContainer;

public class Runtime {
    private static final int MULTIPLE_MODE = 0;
    private static final int SINGLE_MODE = 1;
    private static final int UNKNOWN_MODE = 2;
    private static Runtime theInstance = new Runtime();
    private ThreadGroup criticalThreads;
    private int activeContainers = 0;
    private LinkedList terminators = new LinkedList();
    private AgentContainerImpl theContainer = null;
    private int mode = 2;
    private Logger myLogger = Logger.getMyLogger(this.getClass().getName());

    private Runtime() {
    }

    public static Runtime instance() {
        return theInstance;
    }

    public AgentContainer createAgentContainer(Profile p) {
        if (this.mode == 2 || this.mode == 0) {
            this.mode = 0;
            p.setParameter("main", "false");
            AgentContainerImpl impl = new AgentContainerImpl(p);
            this.beginContainer();
            if (impl.joinPlatform()) {
                return impl.getContainerController();
            }
            return null;
        }
        throw new IllegalStateException("Single-container modality already activated");
    }

    public AgentContainer createMainContainer(Profile p) {
        if (this.mode == 2 || this.mode == 0) {
            this.mode = 0;
            p.setParameter("main", "true");
            AgentContainerImpl impl = new AgentContainerImpl(p);
            this.beginContainer();
            if (impl.joinPlatform()) {
                return impl.getContainerController();
            }
            return null;
        }
        throw new IllegalStateException("Single-container modality already activated");
    }

    public void setCloseVM(boolean flag) {
        if (flag) {
            this.terminators.addLast(new Runnable(){

                public void run() {
                    Thread.yield();
                    Runtime.this.myLogger.log(8, "JADE is closing down now.");
                    System.exit(0);
                }
            });
        }
    }

    public void startUp(Profile p) {
        if (this.mode == 0) {
            throw new IllegalStateException("Multiple-container modality already activated");
        }
        if (this.mode == 2) {
            this.mode = 1;
            this.theContainer = new AgentContainerImpl(p);
            this.beginContainer();
            this.theContainer.joinPlatform();
        }
    }

    public void shutDown() {
        if (this.theContainer != null) {
            this.theContainer.shutDown();
        }
    }

    public void invokeOnTermination(Runnable r) {
        this.terminators.addFirst(r);
    }

    void beginContainer() {
        this.myLogger.log(8, "----------------------------------\n" + Runtime.getCopyrightNotice() + "----------------------------------------");
        if (this.activeContainers == 0) {
            TimerDispatcher theDispatcher = new TimerDispatcher();
            this.criticalThreads = new ThreadGroup("JADE time-critical threads");
            this.criticalThreads.setMaxPriority(10);
            Thread t = new Thread(this.criticalThreads, theDispatcher);
            t.setPriority(this.criticalThreads.getMaxPriority());
            t.setName("JADE Timer dispatcher");
            theDispatcher.setThread(t);
            TimerDispatcher.setTimerDispatcher(theDispatcher);
            theDispatcher.start();
        }
        ++this.activeContainers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void endContainer() {
        --this.activeContainers;
        if (this.activeContainers == 0) {
            Thread t = new Thread(new Runnable(){

                public void run() {
                    int i = 0;
                    while (i < Runtime.this.terminators.size()) {
                        Runnable r = (Runnable)Runtime.this.terminators.get(i);
                        r.run();
                        ++i;
                    }
                }
            });
            t.setDaemon(false);
            TimerDispatcher.getTimerDispatcher().stop();
            this.mode = 2;
            this.theContainer = null;
            try {
                try {
                    this.criticalThreads.destroy();
                }
                catch (IllegalThreadStateException itse) {
                    this.myLogger.log(9, "Time-critical threads still active: ");
                    this.criticalThreads.list();
                    Object var4_3 = null;
                    this.criticalThreads = null;
                }
                Object var4_2 = null;
                this.criticalThreads = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.criticalThreads = null;
                throw throwable;
            }
            t.start();
        }
    }

    public TimerDispatcher getTimerDispatcher() {
        return TimerDispatcher.getTimerDispatcher();
    }

    public static String getCopyrightNotice() {
        return "    This is " + Runtime.getVersionInfo() + "\n    downloaded in Open Source, under LGPL restrictions,\n    at http://jade.tilab.com/\n";
    }

    public static String getVersionInfo() {
        String version = Runtime.getVersion();
        String name = null;
        name = version.startsWith("$") ? "JADE snapshot" : "JADE " + version;
        return name + " - revision " + Runtime.getRevision() + " of " + Runtime.getDate();
    }

    public static String getVersion() {
        String version = "3.4.1";
        return version;
    }

    public static String getRevision() {
        String revision = "5912";
        return revision;
    }

    public static String getDate() {
        String date = "2006/11/16 13:09:18";
        return date;
    }
}

